/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioResourceAssignment;
import filenet.sim.api.VWScenarioRoleAssignment;
import filenet.sim.api.VWScenarioRoleDefinition;
import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMResourceAssignmentWrapper;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.AbstractTableModel;

class VWSIMSelectedResourcesTableModel
extends AbstractTableModel
implements IVWSIMPropertyChangeListener {
    private static final int NUM_COLUMNS = 3;
    public static final int COL_NAME = 0;
    public static final int COL_ROLE = 1;
    public static final int COL_PERFORMANCE = 2;
    protected Vector m_rowData = null;
    protected VWSIMPropertyData m_propertyData = null;
    protected DefaultComboBoxModel m_rolesComboBoxModel = null;
    private VWScenarioShiftDefinition m_shiftDef = null;

    public VWSIMSelectedResourcesTableModel(VWSIMPropertyData propertyData) {
        try {
            this.m_propertyData = propertyData;
            this.m_propertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
            this.m_rowData = new Vector();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize(VWScenarioShiftDefinition shiftDef) throws Exception {
        try {
            VWScenarioRoleAssignment[] roleAssignments;
            this.m_rowData.removeAllElements();
            this.m_shiftDef = shiftDef;
            if (shiftDef != null && (roleAssignments = shiftDef.getRoleAssignments()) != null) {
                for (int i = 0; i < roleAssignments.length; ++i) {
                    VWScenarioResourceAssignment[] resourceAssignments = roleAssignments[i].getResourceAssignments();
                    if (resourceAssignments == null) continue;
                    for (int j = 0; j < resourceAssignments.length; ++j) {
                        this.m_rowData.addElement(new VWSIMResourceAssignmentWrapper(shiftDef, roleAssignments[i], resourceAssignments[j], 1));
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.sortRowData();
    }

    public DefaultComboBoxModel getRoleComboBoxModel() {
        this.updateRoleComboBoxModel();
        return this.m_rolesComboBoxModel;
    }

    public void deleteItem(int nRowIndex) throws Exception {
        VWSIMResourceAssignmentWrapper resAssignment = this.getItemAt(nRowIndex);
        if (resAssignment != null) {
            resAssignment.delete();
            this.m_rowData.removeElementAt(nRowIndex);
            this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            this.notifyPropertyListeners(resAssignment);
        }
    }

    public String[] getSelectedResourceNames() throws Exception {
        if (this.m_rowData != null) {
            VWSIMResourceAssignmentWrapper resAssignment = null;
            String[] names = new String[this.m_rowData.size()];
            for (int i = 0; i < this.m_rowData.size(); ++i) {
                resAssignment = (VWSIMResourceAssignmentWrapper)this.m_rowData.elementAt(i);
                names[i] = resAssignment.getResourceName();
            }
            return names;
        }
        return null;
    }

    public void updateResourceSelection(String[] selectedResourceNames) throws Exception {
        Hashtable<String, String> selectedNames = new Hashtable<String, String>();
        if (selectedResourceNames != null) {
            for (int i = 0; i < selectedResourceNames.length; ++i) {
                selectedNames.put(selectedResourceNames[i], "");
            }
        }
        VWSIMResourceAssignmentWrapper resAssignment = null;
        for (int i = this.m_rowData.size() - 1; i >= 0; --i) {
            resAssignment = (VWSIMResourceAssignmentWrapper)this.m_rowData.elementAt(i);
            if (selectedNames.containsKey(resAssignment.getResourceName())) {
                selectedNames.remove(resAssignment.getResourceName());
                continue;
            }
            this.deleteItem(i);
        }
        Enumeration newNameslist = selectedNames.keys();
        if (newNameslist != null && this.m_shiftDef != null) {
            VWScenarioRoleAssignment roleAssignment = this.m_propertyData.getAvailableRoleAssignment(this.m_shiftDef);
            while (newNameslist.hasMoreElements()) {
                String newResourceName = (String)newNameslist.nextElement();
                VWScenarioResourceAssignment resourceAssignment = roleAssignment.createResourceAssignment(newResourceName, Float.parseFloat("1.0"));
                VWSIMResourceAssignmentWrapper resAssignmentWrapper = new VWSIMResourceAssignmentWrapper(this.m_shiftDef, roleAssignment, resourceAssignment, 1);
                this.m_rowData.addElement(resAssignmentWrapper);
                this.notifyPropertyListeners(resAssignmentWrapper);
            }
        }
        this.sortRowData();
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWSIMResource.s_name;
            }
            case 1: {
                return VWSIMResource.s_job;
            }
            case 2: {
                return VWSIMResource.s_jobEfficiency;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWSIMResourceAssignmentWrapper resAssignment = this.getItemAt(nRowIndex);
            if (resAssignment == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return resAssignment.getResourceName();
                }
                case 1: {
                    return resAssignment.getRoleName();
                }
                case 2: {
                    return resAssignment.getPerformance();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 1: {
                    this.onUpdateRole(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdatePerformace(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void propertyDataChanged(VWSIMPropertyChangeEvent event) {
        switch (event.getID()) {
            case 101: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                this.updateRoleComboBoxModel();
            }
        }
    }

    protected void notifyPropertyListeners(VWSIMResourceAssignmentWrapper resAssignment) {
        this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 109, resAssignment.getResourceName());
    }

    protected VWSIMResourceAssignmentWrapper getItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWSIMResourceAssignmentWrapper)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    protected void sortRowData() {
        try {
            if (this.m_rowData != null && this.m_rowData.size() > 0) {
                Object[] tempArray = new Object[this.m_rowData.size()];
                this.m_rowData.copyInto(tempArray);
                VWQubbleSort.sort(tempArray);
                this.m_rowData = new Vector();
                for (int i = 0; i < tempArray.length; ++i) {
                    this.m_rowData.addElement(tempArray[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.fireTableDataChanged();
    }

    private void onUpdateRole(Object aValue, int nRowIndex) {
        try {
            VWSIMResourceAssignmentWrapper resAssignment;
            if (aValue != null && (resAssignment = this.getItemAt(nRowIndex)) != null) {
                resAssignment.setRoleName((String)aValue);
                this.m_propertyData.setDirty();
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                this.notifyPropertyListeners(resAssignment);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdatePerformace(Object aValue, int nRowIndex) {
        try {
            VWSIMResourceAssignmentWrapper resAssignment;
            if (aValue != null && (resAssignment = this.getItemAt(nRowIndex)) != null) {
                resAssignment.setPerformance((String)aValue);
                this.m_propertyData.setDirty();
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                this.notifyPropertyListeners(resAssignment);
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    private void updateRoleComboBoxModel() {
        VWScenarioRoleDefinition[] roleDefs;
        if (this.m_rolesComboBoxModel == null) {
            this.m_rolesComboBoxModel = new DefaultComboBoxModel();
        } else {
            this.m_rolesComboBoxModel.removeAllElements();
        }
        if (this.m_propertyData != null && (roleDefs = this.m_propertyData.getScenarioDefinition().getRoles()) != null && roleDefs.length > 0) {
            Object[] names = new String[roleDefs.length];
            for (int i = 0; i < roleDefs.length; ++i) {
                names[i] = roleDefs[i].getName();
            }
            try {
                VWQubbleSort.sort(names);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            for (int i = 0; i < names.length; ++i) {
                this.m_rolesComboBoxModel.addElement(names[i]);
            }
        }
    }
}

